/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.rooms.constructions;

import com.badlogic.gdx.math.GridPoint2;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import technology.rocketjump.undermount.gamecontext.GameContext;
import technology.rocketjump.undermount.gamecontext.GameContextAware;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.rooms.constructions.Construction;

@Singleton
public class ConstructionStore
implements GameContextAware {
    private static final List<Construction> emptyArray = new ArrayList<Construction>();
    private final Map<Long, Construction> byId = new ConcurrentHashMap<Long, Construction>();
    private List<Construction> iterableArray = new ArrayList<Construction>();
    private GameContext gameContext;
    private int iterationCursor = 0;

    public void create(Construction construction) {
        for (GridPoint2 tileLocation : construction.getTileLocations()) {
            MapTile tile = this.gameContext.getAreaMap().getTile(tileLocation);
            if (tile.hasConstruction()) {
                System.err.println("ERROR: Construction already exists in target tile");
                return;
            }
            tile.setConstruction(construction);
        }
        this.byId.put(construction.getId(), construction);
    }

    public void remove(Construction construction) {
        this.byId.remove(construction.getId());
    }

    public Construction next() {
        if (this.iterationCursor >= this.iterableArray.size()) {
            this.iterableArray = this.byId.size() > 0 ? new ArrayList<Construction>(this.byId.values()) : emptyArray;
            this.iterationCursor = 0;
        }
        if (this.iterableArray.size() == 0) {
            return null;
        }
        Construction construction = this.iterableArray.get(this.iterationCursor);
        ++this.iterationCursor;
        return construction;
    }

    @Override
    public void onContextChange(GameContext gameContext) {
        this.byId.clear();
        this.iterationCursor = 0;
        this.iterableArray.clear();
        this.gameContext = gameContext;
    }

    public Construction getById(Long targetConstructionId) {
        return this.byId.get(targetConstructionId);
    }
}

